#!/system/bin/sh
MODDIR=${0%/*}

System_Activation()
{
	local wait_start=0
	until [[ $(getprop sys.boot_completed) -eq 1 ]]; do
		local wait_start=$((${wait_start} + 1))
		[[ ${wait_start} -ge 150 ]] && exit 1
		sleep 2
	done
}
System_Activation

sdcard_rw()
{
	local test_file="/sdcard/Android/.TEST_FILE"
	touch $test_file
	while [[ ! -f $test_file ]]; do
		touch $test_file
		sleep 1
	done
	rm $test_file
}
sdcard_rw

log()
{
	echo "$(date '+%T'): $1" >> $2
}

ROOTS()
{
chown root:root "$1"
chmod 777 "$1"
}

[[ ! -d $MODDIR/Script/tmp/ ]] && mkdir -p $MODDIR/Script/tmp/
[[ ! -f /sdcard/Android/步数管理配置/作者主页[root执行前往].sh ]] && cp $MODDIR/Script/Author_Information/作者主页[root执行前往].sh /sdcard/Android/步数管理配置/
[[ ! -f /sdcard/Android/步数管理配置/作者QQ群[root执行前往].sh ]] && cp $MODDIR/Script/Author_Information/作者QQ群[root执行前往].sh /sdcard/Android/步数管理配置/
ROOTS $MODDIR/Script/STEPS
ROOTS $MODDIR/Script/Author_Information/Coolapk
ROOTS $MODDIR/Script/Author_Information/QQGroup

while :
do
	Detect()
	{
		local PROCESS=$(ps -ef | grep STEPS | grep -v grep | wc -l)
		local MODXINXI="$MODDIR/module.prop"
		local LOGTXT="/sdcard/Android/步数管理配置/运行日志/$(date "+%Y-%m-%d").log"

		if [[ ! -f $LOGTXT ]]; then
			if [[ $PROCESS == 0 ]]; then
				nohup $MODDIR/Script/STEPS &
				sleep 2
			fi
		else
			if [[ -e /data/adb/modules/STEPS-Switch/disable ]]; then
				if [[ $PROCESS != 0 ]]; then
					[[ ! -f $MODDIR/Script/tmp/stopping-exit ]] && sed -i "/^description=/c description=当前运行状态: Stopping 已停止" "$MODXINXI"
					[[ ! -f $MODDIR/Script/tmp/stopping-exit ]] && log "<<停止运行:OFF>>" "$LOGTXT"
					[[ ! -f $MODDIR/Script/tmp/stopping-exit ]] && touch $MODDIR/Script/tmp/stopping-exit
				fi
			else
				if [[ $PROCESS == 0 ]]; then
					[[ -f $MODDIR/Script/tmp/stopping-exit ]] && rm -rf $MODDIR/Script/tmp/stopping-exit
					nohup $MODDIR/Script/STEPS &
					sed -i "/^description=/c description=当前运行状态: Running 运行中" "$MODXINXI"
					log "<<开始运行:ON>>" "$LOGTXT"
				else
					if [[ -f $MODDIR/Script/tmp/stopping-exit ]]; then
						rm -rf $MODDIR/Script/tmp/stopping-exit
						sed -i "/^description=/c description=当前运行状态: Running 运行中" "$MODXINXI"
						log "<<取消终止 继续运行>>" "$LOGTXT"
					fi
				fi
			fi
		fi
	}
	Detect
	[[ -f /sdcard/Android/步数管理配置/设置自定义参数.conf.bak ]] && rm /sdcard/Android/步数管理配置/设置自定义参数.conf.bak
	sleep 5
done